/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_SLOT_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class InfoSlot {
    private static Logger log = Logger.getLogger(InfoSlot.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                ResultatInfo resultatInfo = new ResultatInfo("Obtenir des informations sur le slot ");
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                resultatInfo.setInfos(linkedHashMap);
                try {
                    CK_SLOT_INFO cK_SLOT_INFO = pKCS11.C_GetSlotInfo(l);
                    if (cK_SLOT_INFO == null) {
                        resultatInfo.appendTraitement("(C_GetSlotInfo)");
                        log.error((Object)"L'operation a retourne des informations nulles");
                        throw new ExceptionTraitement(7, "L'op\u00e9ration a retourn\u00e9 des informations nulles");
                    }
                    resultatInfo.appendTraitement(new String(cK_SLOT_INFO.slotDescription).trim() + " (C_GetSlotInfo)");
                    linkedHashMap.put("Description du slot", new String(cK_SLOT_INFO.slotDescription));
                    linkedHashMap.put("Identifiant du fabricant du slot", new String(cK_SLOT_INFO.manufacturerID));
                    linkedHashMap.put("La carte est-elle pr\u00e9sente?", (cK_SLOT_INFO.flags & 1L) != 0L ? "Oui" : "Non");
                    linkedHashMap.put("Le lecteur g\u00e8re-t-il les supports amovibles?", (cK_SLOT_INFO.flags & 2L) != 0L ? "Oui" : "Non");
                    linkedHashMap.put("Le slot est-il un slot mat\u00e9riel?", (cK_SLOT_INFO.flags & 4L) != 0L ? "Oui" : "Non");
                    linkedHashMap.put("Version mat\u00e9rielle du slot", cK_SLOT_INFO.hardwareVersion.toString());
                    linkedHashMap.put("Version firmware du slot", cK_SLOT_INFO.firmwareVersion.toString());
                }
                catch (PKCS11Exception pKCS11Exception) {
                    log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                    resultatInfo.setCodeRetour(pKCS11Exception.getErrorCode());
                }
                return resultatInfo;
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(7, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(7, "Une erreur inattendue est survenue");
        }
    }
}

